program mkCrc;
uses SysUtils;
const ISHIELD_MAGIC = $000cc9b8;
      ISHIELD_MAGIC_v2_20_905 = $1234001c;
      ISHIELD_MAGIC_v3_00_065 = $12340016;
      ISHIELD_MAGIC_v5_00_000 = $00010050;


var f : file;
    L : Longint;
    Buffer : array[0..512] of Byte;
    i,R : integer;
begin
   Writeln('mkCrc 04.99 by Sebastian Apel - Installshield ScriptFile CRC Correction');
   Writeln;
   If ParamCount=0 then begin
      Writeln('mkCrc <ScriptFile>');
      Exit;

   end;
   System.Assign(F, ParamStr(1));
{$i-}
   System.Reset(F,1);
{$i+}
   IF IOResult<>0 then WRITELN('Fehler beim ffnen von: '+ParamStr(1));
   Writeln('File   : '+ParaMstr(1));
   L:=0;
   BlockRead(F, L, SizeOf(L));
   IF L<>ISHIELD_MAGIC then begin
      WRITELN(Format('Invalid Installshield Script (Magic: $%x)',[L]));
      exit;
   end;
   BlockRead(F, L, SizeOf(L));
   If L=ISHIELD_MAGIC_v2_20_905 then Writeln('Version: 2') else
   IF L=ISHIELD_MAGIC_v3_00_065 then Writeln('Version: 3') else
   IF L=ISHIELD_MAGIC_v5_00_000 then Writeln('Version: 5') else
   begin
      Writeln('Unknown Version of InstallShield ScriptFile');
      Exit;
   end;



   BlockRead(F, L, SizeOf(L));
   Writeln(Format('OLD CRC: $%x', [L]));
   L:=0;
   While not eof(F) do begin
      BlockRead(F,Buffer, SizeOf(Buffer), R);
      for i:=0 to r-1 do
         L:=L+Buffer[i];
   end;
   Writeln(Format('NEW CRC: $%x',[L]));
   Seek(F,8);
   BlockWrite(F,L,SizeOf(L));
   System.CLose(F);
end.
